dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 8, 180, 360, "assets/images/table/castle_8", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 4, 280, 485, "assets/images/table/castle", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 3, 2, 270, 230, "assets/images/table/castle_2", "assets/images/food/item_mark4", "R" );

numServers = 1;

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 2;
maxCoupleHappiness = 500;

--Level 5.6

--Group 1
guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.likes={female04};
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.likes={female01};
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 50;
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.percentRequestDrink = 100;
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.likes={female01};
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 8, 1000);


--Group 2
guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.likes={female04};
guest.matchType = female01;
LManager:AddGuest(guest);

--guest = LManager.GenGuest(female01);
--guest.matchType = female04;
--LManager:AddGuest(guest);
LManager:SetSeatingGroup(9, 13, 56000);


--Group 3
guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 70;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 90000);

--Group 4
guest = LManager.GenGuest(female01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 20, 120000);


--Group 5
guest = LManager.GenGuest(female03);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 60;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
guest.percentRequestMusic = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 25, 140000);


--Group 6

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female04;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(26, 28, 180000);


--Group 7
guest = LManager.GenGuest(female03);
guest.matchType = female04;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(29, 31, 210000);



LManager:AdjustGuestTolerance(140);



LManager:SetLevelSetting ("dogDelay", 80000);
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 150000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 210000); 
LManager:SetLevelSetting ("speakerChance", 40);

LManager:AddReseatingRequestForGuest(60000, female04);
LManager:AddReseatingRequestForGuest(100000, female03);
LManager:AddReseatingRequestForGuest(200000, female01);
LManager:AddReseatingRequestForGuest(280000, female03);


-- Set up the Level Settings
LManager:SetLevelNumber(5,6);
LManager:SetLevelScores(16500, 19000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/new_dance_3.ogg","assets/audio/music/Dance Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );